package net.wizardsoflua.lua.classes;

import net.minecraft.class_1297;
import net.wizardsoflua.event.EntityDespawnEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaEntityDespawnEvent< //
    J extends EntityDespawnEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<EntityDespawnEvent, LuaEntityDespawnEvent<EntityDespawnEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("EntityDespawnEvent", spellScope, null);
    }

    @Override
    protected final LuaEntityDespawnEvent<EntityDespawnEvent, Class> createNewLuaInstance(
        EntityDespawnEvent javaInstance) {
      return new LuaEntityDespawnEvent<>(this, javaInstance);
    }
  }

  public LuaEntityDespawnEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1297 result = getDelegate().entity();
    return getConverters().toLua(result);
  }
}
