package net.wizardsoflua.lua.classes;

import com.google.common.collect.ImmutableSet;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.WolEvent;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.module.event.EventQueue;
import net.wizardsoflua.spell.SpellScope;

public class LuaEventQueue< //
    J extends EventQueue, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<EventQueue, LuaEventQueue<EventQueue, Class>> {
    public Class(SpellScope spellScope) {
      super("EventQueue", spellScope, null);
      addFunction(new StopFunction());
      addFunction(new LatestFunction());
      addFunction(new NextFunction());
    }

    @Override
    protected final LuaEventQueue<EventQueue, Class> createNewLuaInstance(EventQueue javaInstance) {
      return new LuaEventQueue<>(this, javaInstance);
    }

    private class StopFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "stop";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        EventQueue self = getConverters().toJava(EventQueue.class, arg1, 1, "self", getName());
        self.stop();
        context.getReturnBuffer().setTo();
      }
    }

    private class LatestFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "latest";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        EventQueue self = getConverters().toJava(EventQueue.class, arg1, 1, "self", getName());
        WolEvent result = self.latest();
        Object luaResult = getConverters().toLuaNullable(result);
        context.getReturnBuffer().setTo(luaResult);
      }
    }

    private class NextFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "next";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        EventQueue self = getConverters().toJava(EventQueue.class, arg1, 1, "self", getName());
        Long timeout = getConverters().toJavaNullable(Long.class, arg2, 2, "timeout", getName());
        self.setTimeout(timeout);
        execute(context, self);
      }

      @Override
      public void resume(ExecutionContext context, Object suspendedState)
          throws ResolvedControlThrowable {
        EventQueue eventQueue = (EventQueue) suspendedState;
        execute(context, eventQueue);
      }

      private void execute(ExecutionContext context, EventQueue eventQueue)
          throws ResolvedControlThrowable {
        try {
          eventQueue.pauseIfRequested(context);
        } catch (UnresolvedControlThrowable e) {
          throw e.resolve(NextFunction.this, eventQueue);
        }

        if (!eventQueue.isEmpty()) {
          Object event = eventQueue.pop();
          Object result = getConverters().toLua(event);
          context.getReturnBuffer().setTo(result);
        } else {
          context.getReturnBuffer().setTo();
        }
      }
    }
  }

  public LuaEventQueue(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("names", this::getNames);
    addReadOnly("empty", this::isEmpty);
  }

  private Object getNames() {
    ImmutableSet<String> result = getDelegate().getNames();
    return getConverters().toLuaNullable(result);
  }

  private Object isEmpty() {
    return getConverters().toLua(getDelegate().isEmpty());
  }
}
