package net.wizardsoflua.lua.classes;

import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerAttackBlockEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerAttackBlockEvent< //
    J extends PlayerAttackBlockEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerAttackBlockEvent, LuaPlayerAttackBlockEvent<PlayerAttackBlockEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerAttackBlockEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerAttackBlockEvent<PlayerAttackBlockEvent, Class> createNewLuaInstance(
        PlayerAttackBlockEvent javaInstance) {
      return new LuaPlayerAttackBlockEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerAttackBlockEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("world", this::getWorld);
    addReadOnly("block", this::getBlock);
    addReadOnly("hand", this::getHand);
    addReadOnly("pos", this::getPos);
    addReadOnly("face", this::getFace);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }

  private Object getWorld() {
    class_1937 result = getDelegate().world();
    return getConverters().toLua(result);
  }

  private Object getBlock() {
    class_2680 result = getDelegate().blockState();
    return getConverters().toLua(result);
  }

  private Object getHand() {
    class_1268 result = getDelegate().hand();
    return getConverters().toLua(result);
  }

  private Object getPos() {
    class_2338 result = getDelegate().pos();
    return getConverters().toLua(result);
  }

  private Object getFace() {
    class_2350 result = getDelegate().face();
    return getConverters().toLua(result);
  }
}
