package net.wizardsoflua.lua.classes;

import net.minecraft.class_2487;
import net.minecraft.class_3499;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.spell.SpellScope;

public class LuaStructure< //
    J extends class_3499, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<class_3499, LuaStructure<class_3499, Class>> {
    public Class(SpellScope spellScope) {
      super("Structure", spellScope, null);
    }

    @Override
    protected final LuaStructure<class_3499, Class> createNewLuaInstance(
        class_3499 javaInstance) {
      return new LuaStructure<>(this, javaInstance);
    }
  }

  public LuaStructure(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("size", this::getSize);
    addReadOnly("author", this::getAuthor);
    addReadOnly("nbt", this::getNbt);
  }

  private Object getSize() {
    return getConverters().toLua(getDelegate().method_15160());
  }

  private Object getAuthor() {
    return getConverters().toLuaNullable(getDelegate().method_15181());
  }

  private Object getNbt() {
    return NbtConverter.toLua(getDelegate().method_15175(new class_2487()));
  }
}
