package net.wizardsoflua.lua.classes;

import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5217;
import net.minecraft.class_5217.class_12064;
import net.minecraft.class_7134;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.spell.SpellScope;

public class LuaWorld< //
    J extends class_3218, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<class_3218, LuaWorld<class_3218, Class>> {
    public Class(SpellScope spellScope) {
      super("World", spellScope, null);
      addFunction(new IsLoadedFunction());
    }

    @Override
    protected final LuaWorld<class_3218, Class> createNewLuaInstance(class_3218 javaInstance) {
      return new LuaWorld<>(this, javaInstance);
    }

    class IsLoadedFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "isLoaded";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaWorld<?, ?> self = getConverters().toJava(LuaWorld.class, arg1, 1, "self", getName());
        class_243 pos = getConverters().toJava(class_243.class, arg2, 2, "pos", getName());
        class_3218 world = self.getDelegate();
        class_1923 cp = new class_1923(class_2338.method_49638(pos));
        boolean result = getWorldChunkTracker().isLoaded(world, cp);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }
  }

  public LuaWorld(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("day", this::isDay);
    addReadOnly("night", this::isNight);
    addReadOnly("time", this::getTime);
    addReadOnly("realtime", this::getRealtime);
    addReadOnly("dimension", this::getDimension);
    add("spawnPos", this::getSpawnPos, this::setSpawnPos);
  }

  private Object isDay() {
    return getConverters().toLua(getDelegate().method_8530());
  }

  private Object isNight() {
    return getConverters().toLua(getDelegate().method_23886());
  }

  private Object getTime() {
    return getConverters().toLua(getDelegate().method_8510());
  }

  private Object getRealtime() {
    return getConverters().toLua(System.currentTimeMillis());
  }

  /**
   * @see class_7134
   */
  private Object getDimension() {
    return getConverters().toLua(getDelegate().method_27983().method_29177().toString());
  }

  private Object getSpawnPos() {
    return getConverters().toLua(getDelegate().method_74854().method_74897());
  }

  private void setSpawnPos(Object luaObj) {
    class_2338 pos = getConverters().toJava(class_2338.class, luaObj, "pos");
    class_3218 serverWorld = getDelegate();
    float yaw = 0; // left-right
    float pitch = 0; // up-down
    class_12064 spawnPoint =
        class_5217.class_12064.method_74895(serverWorld.method_27983(), pos, yaw, pitch);
    getDelegate().method_27873(spawnPoint);
  }
}
