package net.wizardsoflua.lua.module.print;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.lib.BasicLib;
import net.sandius.rembulan.runtime.LuaFunction;

public class PrintRedirector {
  public static PrintRedirector installInto(Table env, OutputReceiver outputReceiver) {
    return new PrintRedirector(env, outputReceiver);
  }

  private final OutputReceiver outputReceiver;

  public PrintRedirector(Table env, OutputReceiver outputReceiver) {
    this.outputReceiver = outputReceiver;
    OutputStream out = new ChatOutputStream();
    LuaFunction printFunc = BasicLib.print(out, env);
    env.rawset("print", printFunc);
  }

  private class ChatOutputStream extends org.apache.commons.io.output.ByteArrayOutputStream {
    @Override
    public void flush() throws IOException {
      String message = toString(Charset.defaultCharset());
      message = message.replaceAll("\r", ""); // remove carriage return characters
      // Remove trailing line-feed.
      if (message.endsWith("\n")) {
        message = message.substring(0, message.length() - 1);
      }
      reset();
      print(message);
    }
  }

  private void print(String message) {
    outputReceiver.send(TabEncoder.encode(message));
  }
}
