package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2479;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;

public class NbtByteArrayMerger implements NbtMerger<class_2479> {

  private final NbtConverter converter;

  public NbtByteArrayMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  // @Override
  // public NbtByteArray merge(NbtByteArray nbt, Object data, String key, String path) {
  // if (data instanceof Table) {
  // Table table = (Table) data;
  // NbtByteArray result = (NbtByteArray) nbt.copy();
  // byte[] byteArray = nbt.getByteArray();
  // for (int i = 0; i < byteArray.length; ++i) {
  // Object newLuaValue = table.rawget(i + 1);
  // if (newLuaValue != null) {
  // byte newNbtValue = Conversions.integerValueOf(newLuaValue).byteValue();
  // result.getByteArray()[i] = newNbtValue;
  // }
  // }
  // return result;
  // }
  // throw converter.conversionException(path, data, "table");
  // }

  @Override
  public class_2479 merge(class_2479 nbt, Object data, String key, String path) {
    if (data instanceof Table) {
      Table table = (Table) data;
      if (NbtConverter.isArray(table)) {
        long len = table.rawlen();
        if (len > Integer.MAX_VALUE) {
          throw new UnsupportedOperationException(
              "Can't merge arrays with more that Integer.MAX_VALUE elements!");
        }
        byte[] arr = new byte[(int) len];
        for (int i = 0; i < arr.length; ++i) {
          Object newLuaValue = table.rawget(i + 1);
          if (newLuaValue != null) {
            byte newNbtValue = Conversions.integerValueOf(newLuaValue).byteValue();
            arr[i] = newNbtValue;
          }
        }
        class_2479 result = new class_2479(arr);
        return result;
      }
    }
    throw converter.conversionException(path, data, "table");
  }

}
