package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2503;

public class NbtLongMerger implements NbtMerger<class_2503> {
  private final NbtConverter converter;

  public NbtLongMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2503 merge(class_2503 nbt, Object data, String key, String path) {
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).longValue());
    }
    throw converter.conversionException(path, data, "number");
  }
}
