package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2516;

public class NbtShortMerger implements NbtMerger<class_2516> {
  private final NbtConverter converter;

  public NbtShortMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2516 merge(class_2516 nbt, Object data, String key, String path) {
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).shortValue());
    }
    throw converter.conversionException(path, data, "number");
  }
}
