package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;
import java.util.Map.Entry;
import org.jetbrains.annotations.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.sandius.rembulan.Table;
import net.wizardsoflua.lua.table.TableIterable;

/**
 * Merges {@link class_2499}s of type Compound by matching the elements via the value of the specified
 * key.
 *
 * @author Adrodoc55
 */
public class ValueBasedNbtListMergeStrategy implements NbtListMergeStrategy {
  private final String key;
  private final NbtConverter converter;

  public ValueBasedNbtListMergeStrategy(String key, NbtConverter converter) {
    this.key = checkNotNull(key, "key == null!");
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2499 merge(class_2499 nbt, Table data, String path) {
    class_2499 result = nbt.method_10612();
    for (Entry<Object, Object> entry : new TableIterable(data)) {
      Table luaValue = (Table) entry.getValue();
      Object keyValue = luaValue.rawget(key);
      checkNotNull(keyValue, "Expected each value to contain the key: '" + key + "'");
      class_2487 oldValue = getCompoundByValueKey(nbt, keyValue);
      String entryPath = path + "[" + keyValue + "]";
      if (oldValue != null) {
        class_2520 newValue = converter.merge(oldValue, luaValue, entryPath);
        result.add(newValue);
      } else {
        class_2520 newValue = converter.toNbtCompound(luaValue, entryPath);
        result.add(newValue);
      }
    }
    return result;
  }

  private @Nullable class_2487 getCompoundByValueKey(class_2499 compoundList, Object keyValue) {
    checkNotNull(keyValue, "keyValue == null!");
    for (int i = 0; i < compoundList.size(); ++i) {
      class_2487 compound = compoundList.method_10602(i).orElseThrow();
      class_2520 nbtKeyValue = compound.method_10580(key);
      checkNotNull(nbtKeyValue, "Expected each NBT value to contain the key: '" + key + "'");
      if (nbtKeyValue.equals(keyValue)) {
        return compound;
      }
    }
    return null;
  }
}
