package net.wizardsoflua.mixin.impls;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.mixin.interfaces.ExtendedEntity;

@Mixin(class_1297.class)
public abstract class EntityMixin implements ExtendedEntity {
  private static final String WOL_EXTRA_KEY = "wol:extra"; // TODO remove later

  @Unique
  private boolean wol$legacyMigrated;

  @Override
  public class_2487 getExtra() {
    class_1297 entity = (class_1297) (Object) this;
    class_2487 extra = ((AttachmentTarget) entity).getAttachedOrCreate(attachmentType());
    return extra;
  }

  @Override
  public void setExtra(class_2487 extra) {
    Objects.requireNonNull(extra, "extra");
    class_1297 entity = (class_1297) (Object) this;
    ((AttachmentTarget) entity).setAttached(attachmentType(), extra);
  }

  // Optional: safer mutator so callers don’t forget setAttached after edits
  @Override
  public void modifyExtra(UnaryOperator<class_2487> fn) {
    var entity = (class_1297) (Object) this;
    ((AttachmentTarget) entity).modifyAttached(attachmentType(), cur -> {
      if (cur == null)
        cur = new class_2487();
      return fn.apply(cur);
    });
  }

  @Inject(method = "readData(Lnet/minecraft/storage/ReadView;)V", at = @At("TAIL"))
  private void wol$importLegacy(class_11368 view, CallbackInfo ci) {
    var legacy = view.method_71426(WOL_EXTRA_KEY, class_2487.field_25128);
    legacy.ifPresent(tag -> {
      var at = (AttachmentTarget) (Object) this;
      var current = at.getAttached(attachmentType());
      if (current == null || current.method_33133()) { // do not overwrite
        at.setAttached(attachmentType(), tag.method_10553());
        wol$legacyMigrated = true; // strip once on first save
      }
    });
  }

  @Inject(method = "saveData(Lnet/minecraft/storage/WriteView;)Z", at = @At("TAIL"))
  private void wol$stripLegacy(class_11372 view, CallbackInfoReturnable<Boolean> cir) {
    if (wol$legacyMigrated) {
      view.method_71478("wol:extra"); // delete old field from the just-built save data
      wol$legacyMigrated = false; // do it only once per load cycle
    }
  }

  private AttachmentType<class_2487> attachmentType() {
    return WizardsOfLuaMod.INSTANCE.getExtraEntityAttachmentType();
  }
}
