/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2168;
import net.wizardsoflua.command.dynamic.CommandNodeRemover;
import net.wizardsoflua.command.dynamic.ParseResult;
import net.wizardsoflua.command.dynamic.Token;

public class CommandDef {
    private final String pattern;
    private final String code;
    private final int level;
    private final ParseResult parseResult;
    private Set<String> oldNodes = new HashSet<String>();
    private Set<CommandNode<class_2168>> createdNodes = new HashSet<CommandNode<class_2168>>();

    public CommandDef(String pattern, String code, int level, ParseResult parseResult) {
        this.pattern = pattern;
        this.code = code;
        this.level = level;
        this.parseResult = parseResult;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCode() {
        return this.code;
    }

    public List<Token> getTokens() {
        return this.parseResult.tokens();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTokenPath(int index) {
        return this.parseResult.getTokenPath(index);
    }

    public int findLastPlaceholderIndex() {
        int last = -1;
        for (int i = 0; i < this.getTokens().size(); ++i) {
            if (!this.getTokens().get(i).isPlaceholder()) continue;
            last = i;
        }
        return last;
    }

    public Collection<String> getTokenPaths() {
        return this.parseResult.getTokenPaths();
    }

    public Set<CommandNode<class_2168>> getCreatedNodes() {
        return this.createdNodes;
    }

    public void check(CommandDispatcher<class_2168> dispatcher, Set<CommandNode<class_2168>> allowedNodes) {
        Token tok;
        String nodeName;
        CommandNode child;
        RootCommandNode current = dispatcher.getRoot();
        HashSet<Token> oldNodes = new HashSet<Token>();
        Iterator<Token> iterator = this.getTokens().iterator();
        while (iterator.hasNext() && (child = current.getChild(nodeName = (tok = iterator.next()).tokenName())) != null) {
            oldNodes.add(tok);
            current = child;
        }
        if (oldNodes.size() == this.getTokens().size() && !allowedNodes.contains(current)) {
            throw new IllegalArgumentException("It's not allowed to replace an existing command: " + this.getPattern());
        }
    }

    public void register(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> command) {
        Token tok2;
        String nodeName;
        CommandNode child;
        this.oldNodes.clear();
        RootCommandNode current = dispatcher.getRoot();
        Iterator<Token> iterator = this.getTokens().iterator();
        while (iterator.hasNext() && (child = current.getChild(nodeName = (tok2 = iterator.next()).tokenName())) != null) {
            this.oldNodes.add(tok2.tokenPath());
            current = child;
        }
        dispatcher.register(command);
        current = dispatcher.getRoot();
        for (Token tok2 : this.getTokens()) {
            nodeName = tok2.tokenName();
            child = current.getChild(nodeName);
            if (!this.oldNodes.contains(tok2.tokenPath())) {
                if (child == null) {
                    throw new IllegalStateException("child==null!");
                }
                this.createdNodes.add((CommandNode<class_2168>)child);
            }
            current = child;
        }
    }

    public void deregister(CommandDispatcher<class_2168> dispatcher, CommandNodeRemover commandNodeRemover) {
        Token tok;
        String nodeName;
        CommandNode child;
        RootCommandNode current = dispatcher.getRoot();
        Iterator<Token> iterator = this.getTokens().iterator();
        while (iterator.hasNext() && (child = current.getChild(nodeName = (tok = iterator.next()).tokenName())) != null) {
            if (!this.oldNodes.contains(tok.tokenPath())) {
                commandNodeRemover.removeChildFrom((CommandNode<?>)current, (CommandNode<?>)child);
                break;
            }
            current = child;
        }
        this.oldNodes.clear();
    }
}

