/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.extension.spell.api.resource;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.wizardsoflua.extension.spell.spi.JavaToLuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.lua.BadArgumentException;
import org.jetbrains.annotations.Nullable;

public interface LuaConverters {
    public <J> J castTo(Class<J> var1, Object var2, int var3, String var4, String var5) throws BadArgumentException;

    public <J> Optional<J> castToOptional(Class<J> var1, Object var2, int var3, String var4, String var5) throws BadArgumentException;

    @Nullable
    public <J> List<J> toJavaListNullable(Class<J> var1, @Nullable Object var2, int var3, String var4, String var5);

    public <J> List<J> toJavaList(Class<J> var1, Object var2, int var3, String var4, String var5);

    public <J> Optional<J> toJavaOptional(Class<J> var1, @Nullable Object var2, int var3, String var4, String var5);

    @Nullable
    public <J> J toJavaNullable(Class<J> var1, @Nullable Object var2, int var3, String var4, String var5);

    public <J> J toJava(Class<J> var1, Object var2, int var3, String var4, String var5);

    public <J> List<J> toJavaList(Class<J> var1, Object[] var2, String var3);

    @Nullable
    public <J> List<J> toJavaListNullable(Class<J> var1, @Nullable Object var2, String var3);

    public <J> List<J> toJavaList(Class<J> var1, Object var2, String var3);

    public <J> Optional<J> toJavaOptional(Class<J> var1, @Nullable Object var2, String var3);

    @Nullable
    public <J> J toJavaNullable(Class<J> var1, @Nullable Object var2, String var3);

    public <J> J toJava(Class<J> var1, Object var2, String var3);

    public Optional<? extends Object> toLuaOptional(@Nullable Object var1);

    @Nullable
    public Object toLuaNullable(@Nullable Object var1);

    public <J> Object toLua(J var1);

    public void registerLuaConverter(LuaConverter<?, ?> var1) throws IllegalArgumentException;

    default public <J, L> void registerLuaConverter(String name, final Class<J> javaClass, final Class<L> luaClass, final Function<L, J> getJavaInstance, final Function<J, L> getLuaInstance) throws IllegalArgumentException {
        this.registerLuaConverter(new LuaConverter<J, L>(){

            @Override
            public Class<J> getJavaClass() {
                return javaClass;
            }

            @Override
            public Class<L> getLuaClass() {
                return luaClass;
            }

            @Override
            public J getJavaInstance(L luaInstance) {
                return getJavaInstance.apply(luaInstance);
            }

            @Override
            public L getLuaInstance(J javaInstance) {
                return getLuaInstance.apply(javaInstance);
            }
        });
    }

    public void registerLuaToJavaConverter(LuaToJavaConverter<?, ?> var1) throws IllegalArgumentException;

    public void registerJavaToLuaConverter(JavaToLuaConverter<?> var1) throws IllegalArgumentException;
}

