/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.filesystem;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import java.util.Set;
import net.wizardsoflua.filesystem.DelegatingFileSystem;
import net.wizardsoflua.filesystem.PathUtil;

public class RestrictedFileSystem
extends DelegatingFileSystem {
    private Path rootFolder;

    public RestrictedFileSystem(FileSystem delegate, Path topmostDirectory) {
        super(delegate);
        this.rootFolder = (Path)Preconditions.checkNotNull((Object)topmostDirectory, (Object)"topmostDirectory==null!");
    }

    public Path getRootFolder() {
        return this.rootFolder;
    }

    public boolean isRootFolder(Path path) {
        return this.rootFolder.toAbsolutePath().equals(path.toAbsolutePath());
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (first.startsWith("/")) {
            first = first.substring(1);
        }
        List parts = Lists.asList((Object)first, (Object[])more);
        String filename = Joiner.on((char)File.separatorChar).join((Iterable)parts);
        Path result = PathUtil.toPath(this.rootFolder, filename);
        return result;
    }

    @Override
    public String getSeparator() {
        return super.getSeparator();
    }

    private void throwUnsupported() {
        throw new RuntimeException("Unsupported function in " + RestrictedFileSystem.class.getSimpleName());
    }

    @Override
    public int hashCode() {
        this.throwUnsupported();
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        this.throwUnsupported();
        return super.equals(obj);
    }

    @Override
    public FileSystemProvider provider() {
        this.throwUnsupported();
        return super.provider();
    }

    @Override
    public void close() throws IOException {
        this.throwUnsupported();
        super.close();
    }

    @Override
    public boolean isOpen() {
        this.throwUnsupported();
        return super.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        this.throwUnsupported();
        return super.isReadOnly();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        this.throwUnsupported();
        return super.getRootDirectories();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        this.throwUnsupported();
        return super.getFileStores();
    }

    @Override
    public String toString() {
        this.throwUnsupported();
        return super.toString();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        this.throwUnsupported();
        return super.supportedFileAttributeViews();
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.throwUnsupported();
        return super.getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        this.throwUnsupported();
        return super.getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        this.throwUnsupported();
        return super.newWatchService();
    }
}

