/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.event;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sandius.rembulan.exec.CallException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.scheduling.LuaScheduler;
import org.jetbrains.annotations.Nullable;

public class EventInterceptor {
    private final ImmutableSet<String> names;
    private final LuaFunction eventHandler;
    private final Context context;
    private long luaTicksLimit;
    private boolean pending = false;

    public EventInterceptor(List<String> names, LuaFunction eventHandler, long luaTicksLimit, Context context) {
        this.luaTicksLimit = luaTicksLimit;
        this.names = ImmutableSet.copyOf((Collection)Objects.requireNonNull(names, "names"));
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.context = Objects.requireNonNull(context, "context");
    }

    public ImmutableSet<String> getNames() {
        return this.names;
    }

    public LuaFunction getEventHandler() {
        return this.eventHandler;
    }

    @Nullable
    public Boolean onEvent(Object luaEvent) {
        try {
            Object[] result = this.callDuringEventIntercepting(this.eventHandler, luaEvent);
            if (result == null || result.length < 1) {
                return null;
            }
            return this.context.getConverters().toJavaNullable(Boolean.class, result[0], "result[0]");
        }
        catch (InterruptedException | CallException ex) {
            this.context.handleException("Error in event interceptor", ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] callDuringEventIntercepting(LuaFunction function, Object ... args) throws CallException, InterruptedException {
        boolean oldPending = this.pending;
        this.pending = true;
        try {
            Object[] objectArray = this.context.getScheduler().callUnpausable(this.luaTicksLimit, function, args);
            return objectArray;
        }
        finally {
            this.pending = oldPending;
        }
    }

    public boolean isDuringEventIntercepting() {
        return this.pending;
    }

    public void stop() {
        this.context.stop(this);
    }

    public static interface Context {
        public void stop(EventInterceptor var1);

        public void handleException(String var1, Throwable var2);

        public LuaScheduler getScheduler();

        public Converters getConverters();
    }
}

