/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.searcher;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import net.wizardsoflua.lua.compiler.LuaFunctionBinary;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryByPathCache;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryByUrlCache;

public class LuaFunctionBinaryCache
implements LuaFunctionBinaryByPathCache,
LuaFunctionBinaryByUrlCache {
    private final Map<Object, LuaFunctionBinary> map = new HashMap<Object, LuaFunctionBinary>();
    private final Map<Path, FileTime> cacheDates = new HashMap<Path, FileTime>();

    public void clear() {
        this.map.clear();
        this.cacheDates.clear();
    }

    @Override
    public LuaFunctionBinary get(URL key) {
        return this.map.get(key);
    }

    @Override
    public void put(URL key, LuaFunctionBinary fn) {
        this.map.put(key, fn);
    }

    @Override
    public LuaFunctionBinary get(Path key) throws IOException {
        FileTime lastModified;
        FileTime cacheDate;
        if (Files.isReadable(key) && (cacheDate = this.cacheDates.get(key)) != null && cacheDate.compareTo(lastModified = Files.getLastModifiedTime(key, new LinkOption[0])) == 0) {
            return this.map.get(key);
        }
        return null;
    }

    @Override
    public void put(Path key, LuaFunctionBinary fn) throws IOException {
        FileTime lastModified = Files.getLastModifiedTime(key, new LinkOption[0]);
        this.map.put(key, fn);
        this.cacheDates.put(key, lastModified);
    }
}

