/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.util;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_243;
import net.wizardsoflua.util.MathUtil;
import org.jetbrains.annotations.Nullable;

public enum WolDirection {
    UP("up", new class_243(0.0, 1.0, 0.0)),
    DOWN("down", new class_243(0.0, -1.0, 0.0)),
    NORTH("north", new class_243(0.0, 0.0, -1.0)),
    EAST("east", new class_243(1.0, 0.0, 0.0)),
    SOUTH("south", new class_243(0.0, 0.0, 1.0)),
    WEST("west", new class_243(-1.0, 0.0, 0.0)),
    FORWARD("forward"){

        @Override
        public class_243 getDirectionVec(float rotationYaw) {
            return MathUtil.getVectorForRotation(rotationYaw);
        }
    }
    ,
    BACK("back"){

        @Override
        public class_243 getDirectionVec(float rotationYaw) {
            return MathUtil.getVectorForRotation(rotationYaw + 180.0f);
        }
    }
    ,
    LEFT("left"){

        @Override
        public class_243 getDirectionVec(float rotationYaw) {
            return MathUtil.getVectorForRotation(rotationYaw - 90.0f);
        }
    }
    ,
    RIGHT("right"){

        @Override
        public class_243 getDirectionVec(float rotationYaw) {
            return MathUtil.getVectorForRotation(rotationYaw + 90.0f);
        }
    };

    private static final Map<String, WolDirection> BY_NAME;
    private final String name;
    @Nullable
    private final class_243 vector;

    @Nullable
    public static WolDirection byName(@Nullable String name) {
        return name == null ? null : BY_NAME.get(name.toLowerCase(Locale.ROOT));
    }

    private WolDirection(String name) {
        this(name, null);
    }

    private WolDirection(String name, class_243 directionVec) {
        this.name = name;
        this.vector = directionVec;
    }

    public String getName() {
        return this.name;
    }

    public class_243 getDirectionVec(float rotationYaw) {
        return this.vector;
    }

    static {
        BY_NAME = Maps.newHashMap();
        for (WolDirection value : WolDirection.values()) {
            BY_NAME.put(value.getName(), value);
        }
    }
}

