/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.world;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class WorldChunkTracker {
    private final Map<class_5321<class_1937>, LongOpenHashSet> byDim = new ConcurrentHashMap<class_5321<class_1937>, LongOpenHashSet>();

    public void add(class_1937 world, class_1923 pos) {
        Objects.requireNonNull(world, "world");
        Objects.requireNonNull(pos, "pos");
        class_5321 key = world.method_27983();
        this.byDim.computeIfAbsent((class_5321<class_1937>)key, k -> new LongOpenHashSet()).add(pos.method_8324());
    }

    public void remove(class_1937 world, class_1923 pos) {
        Objects.requireNonNull(world, "world");
        Objects.requireNonNull(pos, "pos");
        class_5321 key = world.method_27983();
        LongOpenHashSet set = this.byDim.get(key);
        if (set != null) {
            set.remove(pos.method_8324());
            if (set.isEmpty()) {
                this.byDim.remove(key);
            }
        }
    }

    public void remove(class_3218 world) {
        class_5321 key = world.method_27983();
        this.byDim.remove(key);
    }

    public void clear() {
        this.byDim.clear();
    }

    public boolean isLoaded(class_1937 world, class_1923 cp) {
        class_3218 sw;
        class_2791 chunk;
        Objects.requireNonNull(world, "world");
        Objects.requireNonNull(cp, "cp");
        LongOpenHashSet set = this.byDim.get(world.method_27983());
        if (set == null || !set.contains(cp.method_8324())) {
            return false;
        }
        if (world instanceof class_3218 && !((chunk = (sw = (class_3218)world).method_8402(cp.field_9181, cp.field_9180, class_2806.field_12803, false)) instanceof class_2818)) {
            set.remove(cp.method_8324());
            if (set.isEmpty()) {
                this.byDim.remove(sw.method_27983());
            }
            return false;
        }
        return true;
    }
}

