package net.wizardsoflua.chunk;

import static com.google.common.base.Preconditions.checkNotNull;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_3218;

class ChunkForce {

  private final class_3218 world;
  private final class_1923 chunkPos;
  private final Set<Ticket> tickets = new HashSet<>();
  private boolean isActive = false;

  public ChunkForce(class_3218 world, class_1923 chunkPos) {
    this.world = checkNotNull(world, "world == null!");
    this.chunkPos = checkNotNull(chunkPos, "chunkPos == null!");
  }

  public boolean add(Ticket ticket) {
    if (tickets.add(ticket)) {
      if (!isActive) {
        isActive = true;
        setChunkForced(chunkPos.field_9181, chunkPos.field_9180, true);
      }
      return true;
    }
    return false;
  }

  public boolean remove(Ticket ticket) {
    if (tickets.remove(ticket)) {
      if (isActive && tickets.isEmpty()) {
        isActive = false;
        setChunkForced(chunkPos.field_9181, chunkPos.field_9180, false);
      }
      return true;
    }
    return false;
  }

  private boolean setChunkForced(int chunkX, int chunkZ, boolean forced) {
    return world.method_17988(chunkX, chunkZ, forced);
  }

}
