package net.wizardsoflua.command;


import static java.util.Objects.requireNonNull;
import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;
import static net.wizardsoflua.WizardsOfLuaMod.WOL_PERMISSION_LEVEL;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_7157;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.spell.SpellCaster;

public class LuaCommand implements CommandRegisterer, Command<class_2168> {
  private static final String PERMISSION = WizardsOfLuaMod.MOD_ID + ".lua";
  private final SpellCaster spellCaster;

  public LuaCommand(SpellCaster spellCaster) {
    this.spellCaster = requireNonNull(spellCaster, "spellCaster");
  }

  @Override
  public void register(CommandDispatcher<class_2168> dispatcher,
      class_7157 registryAccess, class_5364 environment) {
    dispatcher.register(//
        method_9247("lua")//
            .requires(source -> source.method_9228() == null
                || Permissions.check(source, PERMISSION, WOL_PERMISSION_LEVEL)) //
            .then(method_9244("code", StringArgumentType.greedyString())//
                .executes(this)));
  }

  @Override
  public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
    class_2168 source = context.getSource();
    String code = StringArgumentType.getString(context, "code");
    return spellCaster.castNewSpell(source, code);
  }
}
