package net.wizardsoflua.command.dynamic;

import java.util.List;

/**
 * A single piece of a dynamic‐command pattern: either a literal word or a placeholder.
 *
 * @param raw the original token text, e.g. "foo:%d", "%item", or "baz"
 * @param tokenPath the path to the token
 * @param tokenName the name of the token
 * @param isPlaceholder true if this token represents a %… placeholder
 * @param placeholderName the placeholder’s name (null for unnamed placeholders & literals)
 * @param placeholder the placeholder type enum (null for literal tokens)
 * @param enumValues if non-null, the allowed values for a %s[...] enum‐placeholder
 */
public record Token(String raw, String tokenPath, String tokenName, boolean isPlaceholder,
    String placeholderName, Placeholder placeholder, List<String> enumValues) {
  /** @return true if this is a named placeholder (i.e. isPlaceholder && name != null) */
  public boolean isNamedPlaceholder() {
    return isPlaceholder && placeholderName != null;
  }
}
