package net.wizardsoflua.event;

import net.minecraft.class_1282;
import net.minecraft.class_1309;

/**
 * Called after a living entity took damage, unless they were killed. The base damage taken is given
 * as damage taken before armor or enchantments are applied, but after other effects like shields
 * are applied.
 *
 * @param entity the entity that was damaged
 * @param damageSource the source of the damage
 * @param damageDealt the amount of damage initially dealt
 * @param damageTaken the amount of damage actually taken by the entity, before armor and
 *        enchantment effects
 * @param blocked whether the damage was blocked by a shield
 */
public record AfterLivingEntityDamageEvent(class_1309 entity, class_1282 damageSource,
    float damageDealt, float damageTaken, boolean blocked) implements WolEvent {
  @Override
  public boolean canBeCanceled() {
    return false;
  }
}
