package net.wizardsoflua.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.wizardsoflua.spell.Spell;

public interface SpellFinishCallback {

  Event<SpellFinishCallback> EVENT =
      EventFactory.createArrayBacked(SpellFinishCallback.class, (listeners) -> spell -> {
        for (SpellFinishCallback listener : listeners) {
          listener.onSpellFinish(spell);
        }
      });

  void onSpellFinish(Spell spell);
}
