package net.wizardsoflua.lua.classes;

import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.wizardsoflua.event.ChatMessageEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaChatMessageEvent< //
    J extends ChatMessageEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<ChatMessageEvent, LuaChatMessageEvent<ChatMessageEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("ChatMessageEvent", spellScope, null);
    }

    @Override
    protected final LuaChatMessageEvent<ChatMessageEvent, Class> createNewLuaInstance(
        ChatMessageEvent javaInstance) {
      return new LuaChatMessageEvent<>(this, javaInstance);
    }
  }

  public LuaChatMessageEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("sender", this::getSender);
    addReadOnly("message", this::getMessage);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getSender() {
    class_3222 sender = getDelegate().sender();
    return getConverters().toLua(sender);
  }

  private Object getMessage() {
    class_2561 message = getDelegate().message();
    return getConverters().toLua(message);
  }
}
