package net.wizardsoflua.lua.classes;

import net.minecraft.class_1297;
import net.wizardsoflua.event.EntitySpawnEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaEntitySpawnEvent< //
    J extends EntitySpawnEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<EntitySpawnEvent, LuaEntitySpawnEvent<EntitySpawnEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("EntitySpawnEvent", spellScope, null);
    }

    @Override
    protected final LuaEntitySpawnEvent<EntitySpawnEvent, Class> createNewLuaInstance(
        EntitySpawnEvent javaInstance) {
      return new LuaEntitySpawnEvent<>(this, javaInstance);
    }
  }

  public LuaEntitySpawnEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("entity", this::getEntity);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getEntity() {
    class_1297 result = getDelegate().entity();
    return getConverters().toLua(result);
  }
}
