package net.wizardsoflua.lua.classes;

import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerDisconnectedEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerDisconnectedEvent< //
    J extends PlayerDisconnectedEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerDisconnectedEvent, LuaPlayerDisconnectedEvent<PlayerDisconnectedEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerDisconnectedEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerDisconnectedEvent<PlayerDisconnectedEvent, Class> createNewLuaInstance(
        PlayerDisconnectedEvent javaInstance) {
      return new LuaPlayerDisconnectedEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerDisconnectedEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    class_3222 result = getDelegate().player();
    return getConverters().toLua(result);
  }
}
