package net.wizardsoflua.lua.classes;

import net.wizardsoflua.event.PlayerDropItemEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerDropItemEvent< //
    J extends PlayerDropItemEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerDropItemEvent, LuaPlayerDropItemEvent<PlayerDropItemEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerDropItemEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerDropItemEvent<PlayerDropItemEvent, Class> createNewLuaInstance(
        PlayerDropItemEvent javaInstance) {
      return new LuaPlayerDropItemEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerDropItemEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("player", this::getPlayer);
    addReadOnly("droppedItem", this::getDroppedItem);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getPlayer() {
    return getConverters().toLua(getDelegate().player());
  }

  private Object getDroppedItem() {
    return getConverters().toLuaNullable(getDelegate().droppedItem());
  }
}
