package net.wizardsoflua.lua.classes;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.mixin.interfaces.WolStructureTemplateManager;
import net.wizardsoflua.spell.SpellScope;

public class LuaServer< //
    J extends MinecraftServer, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<MinecraftServer, LuaServer<MinecraftServer, Class>> {
    public Class(SpellScope spellScope) {
      super("Server", spellScope, null);
      addFunction(new GetWorldFunction());
      addFunction(new LoadStructureFunction());
      addFunction(new SaveStructureFunction());
    }

    @Override
    protected final LuaServer<MinecraftServer, Class> createNewLuaInstance(
        MinecraftServer javaInstance) {
      return new LuaServer<>(this, javaInstance);
    }

    class GetWorldFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "getWorld";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object dimensionArg)
          throws ResolvedControlThrowable {
        LuaServer<?, ?> self =
            getConverters().castTo(LuaServer.class, selfArg, 1, "self", getName());
        String dimension =
            getConverters().toJava(String.class, dimensionArg, 2, "dimension", getName());
        class_5321<class_1937> regKey = class_5321.method_29179(class_7924.field_41223, class_2960.method_60654(dimension));
        class_3218 world = self.getDelegate().method_3847(regKey);
        context.getReturnBuffer().setTo(getConverters().toLua(world));
      }
    }

    class LoadStructureFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "loadStructure";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object nameArg)
          throws ResolvedControlThrowable {
        LuaServer<?, ?> self =
            getConverters().castTo(LuaServer.class, selfArg, 1, "self", getName());
        String name = getConverters().toJava(String.class, nameArg, 2, "name", getName());

        class_3218 world = getWorld();
        class_3485 mgr = world.method_14183();
        class_2960 id = class_2960.method_60654(name);
        class_3499 result = mgr.method_15094(id).orElseThrow(() -> {
          throw new IllegalArgumentException("Can't find structure \"" + name + "\"");
        });
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }
    }

    class SaveStructureFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "saveStructure";
      }

      @Override
      public void invoke(ExecutionContext context, Object selfArg, Object nameArg, Object structArg)
          throws ResolvedControlThrowable {
        LuaServer<?, ?> self =
            getConverters().castTo(LuaServer.class, selfArg, 1, "self", getName());
        String name = getConverters().toJava(String.class, nameArg, 2, "name", getName());
        class_3499 template =
            getConverters().toJava(class_3499.class, structArg, 3, "struct", getName());

        class_3218 world = getWorld();
        class_3485 mgr = world.method_14183();
        class_2960 id = class_2960.method_60654(name);
        ((WolStructureTemplateManager) mgr).saveTemplate(id, template);

        Path file = mgr.method_15085(id, ".nbt");
        Path rootDir = getWolServerFileSystem().getRootFolder();
        Path relativeFilePath = rootDir.relativize(file);
        String result = relativeFilePath.toString();
        context.getReturnBuffer().setTo(getConverters().toLua(result));
      }
    }
  }

  public LuaServer(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("version", this::getVersion);
    addReadOnly("filesystem", this::getFilesystem);
    addReadOnly("players", this::getPlayers);
  }

  private Object getVersion() {
    return getConverters().toLua(getDelegate().method_3827());
  }

  private Object getFilesystem() {
    WolServerFileSystem result = getLuaClass().getWolServerFileSystem();
    return getConverters().toLua(result);
  }

  private Object getPlayers() {
    List<class_3222> players = getDelegate().method_3760().method_14571();
    return getConverters().toLua(players);
  }
}
