package net.wizardsoflua.lua.classes;

import net.wizardsoflua.event.SpellFinishEvent;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellScope;

public class LuaSpellFinishEvent< //
    J extends SpellFinishEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<SpellFinishEvent, LuaSpellFinishEvent<SpellFinishEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("SpellFinishEvent", spellScope, null);
    }

    @Override
    protected final LuaSpellFinishEvent<SpellFinishEvent, Class> createNewLuaInstance(
        SpellFinishEvent javaInstance) {
      return new LuaSpellFinishEvent<>(this, javaInstance);
    }
  }

  public LuaSpellFinishEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("spell", this::getSpell);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getSpell() {
    Spell result = getDelegate().spell();
    return getConverters().toLua(result);
  }
}
