package net.wizardsoflua.lua.module.wol;

import static java.util.Objects.requireNonNull;
import java.util.function.Supplier;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.wizardsoflua.command.dynamic.DynamicCommandManager;

/**
 * Core module exposed to Lua as `WizardsOfLua`, now carrying an injected DynamicCommandManager.
 */
public class WolModule {
  public static final String NAME = "WizardsOfLua";

  private final Supplier<String> versionSupplier;
  private final Supplier<DynamicCommandManager> commandManagerSupplier;

  private LogTarget logTarget;
  private Table global;

  public WolModule(Supplier<String> versionSupplier,
      Supplier<DynamicCommandManager> commandManagerSupplier) {
    this.versionSupplier = requireNonNull(versionSupplier, "versionSupplier");
    this.commandManagerSupplier = requireNonNull(commandManagerSupplier, "commandManager");
    reset();
  }

  public String getVersion() {
    return versionSupplier.get();
  }

  public LogTarget getLog() {
    return logTarget;
  }

  public void setLog(LogTarget logTarget) {
    this.logTarget = requireNonNull(logTarget, "logTarget");
  }

  public Table getGlobal() {
    return global;
  }

  public DynamicCommandManager getCommandManager() {
    return commandManagerSupplier.get();
  }

  public void reset() {
    logTarget = LogTarget.source;
    global = DefaultTable.factory().newTable();
    DynamicCommandManager mgr = getCommandManager();
    if (mgr != null) {
      mgr.clearAll();
    }
  }
}
