package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2489;

public class NbtDoubleMerger implements NbtMerger<class_2489> {
  private final NbtConverter converter;

  public NbtDoubleMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2489 merge(class_2489 nbt, Object data, String key, String path) {
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).doubleValue());
    }
    throw converter.conversionException(path, data, "number");
  }
}
