package net.wizardsoflua.lua.nbt;

import static com.google.common.base.Preconditions.checkNotNull;

import net.minecraft.class_2494;

public class NbtFloatMerger implements NbtMerger<class_2494> {
  private final NbtConverter converter;

  public NbtFloatMerger(NbtConverter converter) {
    this.converter = checkNotNull(converter, "converter == null!");
  }

  @Override
  public class_2494 merge(class_2494 nbt, Object data, String key, String path) {
    if (data instanceof Number) {
      return NbtConverter.toNbt(((Number) data).floatValue());
    }
    throw converter.conversionException(path, data, "number");
  }
}
