package net.wizardsoflua.lua.table;

import static com.google.common.base.Preconditions.checkNotNull;
import net.wizardsoflua.lua.classes.Delegator;

public class XDelegatingLuaTable<D> extends PropertyTable implements Delegator<D> {
  private D delegate;

  public XDelegatingLuaTable(D delegate, boolean allowAdditionalProperties) {
    super(allowAdditionalProperties);
    this.delegate = checkNotNull(delegate, "delegate == null!");
  }

  @Override
  public D getDelegate() {
    return delegate;
  }

  protected void setDelegate(D delegate) {
    this.delegate = delegate;
  }
}
