package net.wizardsoflua.mixin.impls;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.wizardsoflua.event.PlayerDropItemCallback;
import net.wizardsoflua.event.PlayerDropSelectedItemCallback;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin {
  @Inject(method = "dropSelectedItem(Z)Z", at = @At("HEAD"), cancellable = true)
  private void onDropSelectedItem(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
    class_3222 player = (class_3222) (Object) this;
    class_1799 stack = player.method_31548().method_7391();
    if (!stack.method_7960()) {
      boolean proceed = PlayerDropSelectedItemCallback.EVENT.invoker().onDropSelectedItem(player,
          stack, entireStack);
      if (!proceed) {
        // only need this; setReturnValue(true/false) auto-cancels
        cir.setReturnValue(false);
        // Sync player status or otherwise the client thinks the item has been dropped
        player.method_5682().method_3760().method_14594(player);
      }
    }
  }

  // net.minecraft.server.network.ServerPlayerEntity.dropItem(ItemStack, boolean, boolean)
  @Inject(method = "dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;",
      at = @At("RETURN"))
  private void onDropItem(class_1799 stack, boolean throwRandomly, boolean retainOwnership,
      CallbackInfoReturnable<class_1542> cir) {
    if ((Object) this instanceof class_3222 player) {
      class_1542 itemEntity = cir.getReturnValue();
      if (itemEntity != null) {
        PlayerDropItemCallback.EVENT.invoker().onDropItem(player, itemEntity);
      }
    }
  }
}
