package net.wizardsoflua.spell;

import static java.util.Objects.requireNonNull;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Command;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8828;
import net.wizardsoflua.WizardsOfLuaMod;

public class SpellCaster {
  private final SpellFactory spellFactory;

  public SpellCaster(SpellFactory spellFactory) {
    this.spellFactory = requireNonNull(spellFactory, "spellFactory");
  }

  public int castNewSpell(class_2168 source, String code) {
    return castNewSpell(source, code, Maps.newLinkedHashMap());
  }

  public int castNewSpell(class_2168 source, String code,
      LinkedHashMap<Object, Object> argsMap) {
    try {
      spellFactory.createSpell(source, code, argsMap);
      return Command.SINGLE_SUCCESS;
    } catch (Throwable t) {
      // FIXME check if we need to check for exceptions here or at some other place
      handleException(t, source);
      return 0;
    }
  }

  private void handleException(Throwable t, class_2168 source) {
    String message = String.format("An unexpected error occured during lua command execution: %s",
        t.getMessage());
    WizardsOfLuaMod.LOGGER.error(message, t);
    String stackTrace = getStackTrace(t);
    class_2561 errorText = class_5250.method_43477(class_8828.method_54232(message)).method_27693(stackTrace);
    source.method_9213(errorText);
  }

  private String getStackTrace(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    String result = writer.toString();
    if (result.length() > 200) {
      result = result.substring(0, 200) + "...";
    }
    return result;
  }
}
