package net.wizardsoflua.startup;

import static java.util.Objects.requireNonNull;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8828;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.spell.SpellCaster;
import net.wizardsoflua.spell.SpellRegistry;

public class Startup {
  private final WolDirectories directories;
  private final SpellRegistry spellRegistry;
  private final SpellCaster spellCaster;
  private final WolModule wolModule;
  private final StartupModuleFinder startupModuleFinder = new StartupModuleFinder();

  public Startup(WolDirectories directories, SpellRegistry spellRegistry, SpellCaster spellCaster,
      WolModule wolModule) {
    this.directories = requireNonNull(directories, "directories");
    this.spellRegistry = requireNonNull(spellRegistry, "spellRegistry");;
    this.spellCaster = requireNonNull(spellCaster, "spellCaster");
    this.wolModule = requireNonNull(wolModule, "wolModule");;
  }

  public int run(class_2168 source) {
    wolModule.reset();
    spellRegistry.breakSpells(spellRegistry.getAll());

    int result = 0;
    try {
      Path dir = directories.getLuaSrcDir();
      List<String> startupModules = startupModuleFinder.findStartupModulesIn(dir);
      for (String module : startupModules) {
        result += spellCaster.castNewSpell(source, "require(\"" + module + "\")");
      }
    } catch (IOException e) {
      handleException(e, source);
    }
    return result;
  }

  private void handleException(Throwable t, class_2168 source) {
    String message =
        String.format("An unexpected error occured during startup sequence: %s", t.getMessage());
    WizardsOfLuaMod.LOGGER.error(message, t);
    String stackTrace = getStackTrace(t);
    class_2561 errorText = class_5250.method_43477(class_8828.method_54232(message)).method_27693(stackTrace);
    source.method_9213(errorText);
  }

  private String getStackTrace(Throwable throwable) {
    StringWriter writer = new StringWriter();
    throwable.printStackTrace(new PrintWriter(writer));
    String result = writer.toString();
    if (result.length() > 200) {
      result = result.substring(0, 200) + "...";
    }
    return result;
  }
}
