package net.wizardsoflua.util;

import java.util.Locale;
import java.util.Map;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import com.google.common.collect.Maps;

public enum WolDirection {
  UP("up", new class_243(0, 1, 0)), //
  DOWN("down", new class_243(0, -1, 0)), //
  NORTH("north", new class_243(0, 0, -1)), //
  EAST("east", new class_243(1, 0, 0)), //
  SOUTH("south", new class_243(0, 0, 1)), //
  WEST("west", new class_243(-1, 0, 0)), //
  FORWARD("forward") {
    @Override
    public class_243 getDirectionVec(float rotationYaw) {
      return MathUtil.getVectorForRotation(rotationYaw);
    }
  }, //
  BACK("back") {
    @Override
    public class_243 getDirectionVec(float rotationYaw) {
      return MathUtil.getVectorForRotation(rotationYaw + 180);
    }
  }, //
  LEFT("left") {
    @Override
    public class_243 getDirectionVec(float rotationYaw) {
      return MathUtil.getVectorForRotation(rotationYaw - 90);
    }
  }, //
  RIGHT("right") {
    @Override
    public class_243 getDirectionVec(float rotationYaw) {
      return MathUtil.getVectorForRotation(rotationYaw + 90);
    }
  };

  private static final Map<String, WolDirection> BY_NAME = Maps.<String, WolDirection>newHashMap();
  static {
    for (WolDirection value : WolDirection.values()) {
      BY_NAME.put(value.getName(), value);
    }
  }

  public static @Nullable WolDirection byName(@Nullable String name) {
    return name == null ? null : (WolDirection) BY_NAME.get(name.toLowerCase(Locale.ROOT));
  }

  private final String name;
  private final @Nullable class_243 vector;

  private WolDirection(String name) {
    this(name, null);
  }

  private WolDirection(String name, class_243 directionVec) {
    this.name = name;
    this.vector = directionVec;
  }

  public String getName() {
    return name;
  }

  public class_243 getDirectionVec(float rotationYaw) {
    return vector;
  }
}