package net.wizardsoflua.command;

import static com.mojang.brigadier.arguments.IntegerArgumentType.integer;
import static com.mojang.brigadier.arguments.StringArgumentType.string;
import static java.util.Objects.requireNonNull;
import static net.minecraft.class_2186.method_9305;
import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;
import static net.wizardsoflua.WizardsOfLuaMod.WOL_PERMISSION_LEVEL;
import java.util.Objects;
import java.util.function.Predicate;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;

public class WolSpellBreakCommand implements CommandRegisterer {
  private static final String WOL_PERMISSION = WizardsOfLuaMod.MOD_ID + ".wol";
  private static final String WOL_SPELL_PERMISSION = WOL_PERMISSION + ".spell";
  private static final String WOL_SPELL_BREAK_PERMISSION = WOL_SPELL_PERMISSION + ".break";

  private static final String SID_ARG = "sid";
  private static final String NAME_ARG = "name";
  private static final String OWNER_ARG = "owner";

  private final SpellRegistry spellRegistry;

  public WolSpellBreakCommand(SpellRegistry spellRegistry) {
    this.spellRegistry = requireNonNull(spellRegistry, "spellRegistry");
  }

  @Override
  public void register(CommandDispatcher<class_2168> d,
      class_7157 registryAccess, class_5364 environment) {
    d.register(//
        method_9247("wol")//
            .requires(source -> source.method_9228() == null
                || Permissions.check(source, WOL_PERMISSION, WOL_PERMISSION_LEVEL)) //
            .then(method_9247("spell") //
                .requires(source -> source.method_9228() == null
                    || Permissions.check(source, WOL_SPELL_PERMISSION, WOL_PERMISSION_LEVEL)) //
                .then(method_9247("break") //
                    .requires(source -> source.method_9228() == null || Permissions.check(source,
                        WOL_SPELL_BREAK_PERMISSION, WOL_PERMISSION_LEVEL)) //
                    .executes(this::breakByCaller)//
                    .then(method_9247("all") //
                        .requires(source -> source.method_9228() == null || Permissions.check(source,
                            WOL_SPELL_BREAK_PERMISSION + ".all", WOL_PERMISSION_LEVEL)) //
                        .executes(this::breakAll)) //
                    .then(method_9247("bySid") //
                        .requires(source -> source.method_9228() == null || Permissions.check(source,
                            WOL_SPELL_BREAK_PERMISSION + ".bySid", WOL_PERMISSION_LEVEL)) //
                        .then(method_9244(SID_ARG, integer(0)) //
                            .executes(this::breakBySid))) //
                    .then(method_9247("byName") //
                        .requires(source -> source.method_9228() == null || Permissions.check(source,
                            WOL_SPELL_BREAK_PERMISSION + ".byName", WOL_PERMISSION_LEVEL)) //
                        .then(method_9244(NAME_ARG, string()) //
                            .executes(this::breakByName))) //
                    .then(method_9247("byOwner") //
                        .requires(source -> source.method_9228() == null || Permissions.check(source,
                            WOL_SPELL_BREAK_PERMISSION + ".byOwner", WOL_PERMISSION_LEVEL)) //
                        .then(method_9244(OWNER_ARG, method_9305()) //
                            .executes(this::breakByOwner))))));
  }

  public int breakByCaller(CommandContext<class_2168> context)
      throws CommandSyntaxException {
    class_2168 source = context.getSource();
    class_1297 entity = source.method_9228();
    return breakSpells(source, spell -> Objects.equals(entity, spell.getOwner()));
  }

  public int breakAll(CommandContext<class_2168> context) throws CommandSyntaxException {
    class_2168 source = context.getSource();
    Iterable<Spell> spells = spellRegistry.getAll();
    return breakSpells(source, spells);
  }

  public int breakBySid(CommandContext<class_2168> context) throws CommandSyntaxException {
    int sid = IntegerArgumentType.getInteger(context, SID_ARG);
    class_2168 source = context.getSource();
    return breakSpells(source, spell -> sid == spell.getSid());
  }

  public int breakByName(CommandContext<class_2168> context)
      throws CommandSyntaxException {
    String name = StringArgumentType.getString(context, NAME_ARG);
    class_2168 source = context.getSource();
    return breakSpells(source, spell -> name.equals(spell.getName()));
  }

  public int breakByOwner(CommandContext<class_2168> context)
      throws CommandSyntaxException {
    class_3222 owner = class_2186.method_9315(context, OWNER_ARG);
    class_2168 source = context.getSource();
    return breakSpells(source, spell -> owner.equals(spell.getOwner()));
  }

  private int breakSpells(class_2168 source, Predicate<Spell> predicate) {
    Iterable<Spell> spells = spellRegistry.get(predicate);
    return breakSpells(source, spells);
  }

  private int breakSpells(class_2168 source, Iterable<Spell> spells) {
    int count = spellRegistry.breakSpells(spells);
    if (count == 0) {
      source.method_9226(() -> class_2561.method_30163("No spells found"), false);
    } else if (count == 1) {
      // TODO I18n
      source.method_9226(() -> class_2561.method_30163("Broke 1 spell"), false);
    } else {
      // TODO I18n
      int i = count;
      source.method_9226(() -> class_2561.method_30163("Broke " + i + " spells"), false);
    }
    return count;
  }
}
