package net.wizardsoflua.extension.spell.api.resource;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import net.wizardsoflua.extension.spell.spi.JavaToLuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.lua.BadArgumentException;

public interface LuaConverters {
  <J> J castTo(Class<J> type, Object luaObject, int argumentIndex, String argumentName,
      String functionOrPropertyName) throws BadArgumentException;

  <J> Optional<J> castToOptional(Class<J> type, Object luaObject, int argumentIndex,
      String argumentName, String functionOrPropertyName) throws BadArgumentException;

  @Nullable
  <J> List<J> toJavaListNullable(Class<J> type, @Nullable Object luaObject, int argumentIndex,
      String argumentName, String functionOrPropertyName);

  <J> List<J> toJavaList(Class<J> type, Object luaObject, int argumentIndex, String argumentName,
      String functionOrPropertyName);

  <J> Optional<J> toJavaOptional(Class<J> type, @Nullable Object luaObject, int argumentIndex,
      String argumentName, String functionOrPropertyName);

  @Nullable
  <J> J toJavaNullable(Class<J> type, @Nullable Object luaObject, int argumentIndex,
      String argumentName, String functionOrPropertyName);

  <J> J toJava(Class<J> type, Object luaObject, int argumentIndex, String argumentName,
      String functionOrPropertyName);

  <J> List<J> toJavaList(Class<J> type, Object[] args, String functionOrPropertyName);

  @Nullable
  <J> List<J> toJavaListNullable(Class<J> type, @Nullable Object luaObject,
      String functionOrPropertyName);

  <J> List<J> toJavaList(Class<J> type, Object luaObject, String functionOrPropertyName);

  <J> Optional<J> toJavaOptional(Class<J> type, @Nullable Object luaObject,
      String functionOrPropertyName);

  @Nullable
  <J> J toJavaNullable(Class<J> type, @Nullable Object luaObject, String functionOrPropertyName);

  <J> J toJava(Class<J> type, Object luaObject, String functionOrPropertyName);

  Optional<? extends Object> toLuaOptional(@Nullable Object value);

  @Nullable
  Object toLuaNullable(@Nullable Object value);

  <J> Object toLua(J javaObject);

  void registerLuaConverter(LuaConverter<?, ?> converter) throws IllegalArgumentException;

  default <J, L> void registerLuaConverter(String name, Class<J> javaClass, Class<L> luaClass,
      Function<L, J> getJavaInstance, Function<J, L> getLuaInstance)
      throws IllegalArgumentException {
    registerLuaConverter(new LuaConverter<J, L>() {
      @Override
      public Class<J> getJavaClass() {
        return javaClass;
      }

      @Override
      public Class<L> getLuaClass() {
        return luaClass;
      }

      @Override
      public J getJavaInstance(L luaInstance) {
        return getJavaInstance.apply(luaInstance);
      }

      @Override
      public L getLuaInstance(J javaInstance) {
        return getLuaInstance.apply(javaInstance);
      }
    });
  }

  void registerLuaToJavaConverter(LuaToJavaConverter<?, ?> converter)
      throws IllegalArgumentException;

  void registerJavaToLuaConverter(JavaToLuaConverter<?> converter) throws IllegalArgumentException;
}
