package net.wizardsoflua.lua.classes;

import java.util.Optional;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.BadArgumentException;
import net.wizardsoflua.lua.RaycastUtil;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.mixin.interfaces.ExtendedEntity;
import net.wizardsoflua.spell.SpellScope;

public class LuaEntity< //
    J extends class_1297, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends AbstractLuaClass<class_1297, LuaEntity<class_1297, Class>> {
    public Class(SpellScope spellScope) {
      super("Entity", spellScope, null);
      addFunction(new PutNbtFunction());
      addFunction(new KillFunction());
      addFunction(new RaycastBlockFunction());
      addFunction(new RaycastEntityFunction());
      addFunction(new RaycastFunction());
      addFunction(new DropItemFunction());
      addFunction(new EvaluateFunction());
      addFunction(new PutExtraFunction());
    }

    @Override
    protected final LuaEntity<class_1297, Class> createNewLuaInstance(class_1297 javaInstance) {
      return new LuaEntity<>(this, javaInstance);
    }

    class PutNbtFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "putNbt";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        Table nbt = getConverters().toJava(Table.class, arg2, 2, "nbt", getName());
        self.putNbt(nbt);
        context.getReturnBuffer().setTo();
      }
    }

    class KillFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "kill";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        class_3218 world = (class_3218) self.getDelegate().method_37908();
        self.getDelegate().method_5768(world);
        context.getReturnBuffer().setTo();
      }
    }

    class RaycastBlockFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "raycastBlock";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        class_1297 entity = self.getDelegate();
        class_3965 result = RaycastUtil.raycastFromEyeToBlock(entity, maxDistance);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class RaycastEntityFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "raycastEntity";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        class_1297 entity = self.getDelegate();
        class_3966 result = RaycastUtil.raycastFromEyeToEntity(entity, maxDistance);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class RaycastFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "raycast";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        double maxDistance =
            getConverters().toJava(double.class, arg2, 2, "maxDistance", getName());
        class_1297 entity = self.getDelegate();
        class_239 result = RaycastUtil.raycastFromEye(entity, maxDistance);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(result));
      }
    }

    class DropItemFunction extends NamedFunction3 {
      @Override
      public String getName() {
        return "dropItem";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        String typeName = getTypes().getLuaTypeNameOfLuaObject(arg2);
        float yOffset =
            getConverters().toJavaOptional(float.class, arg3, 3, "yOffset", getName()).orElse(0f);

        class_1799 itemStack = switch (typeName) {
          case LuaItem.Class.NAME -> //
              getConverters().toJava(class_1799.class, arg2, "item");
          case LuaBlockType.Class.NAME -> //
              new class_1799(getConverters().toJava(class_2248.class, arg2, "blockType"));
          case LuaItemType.Class.NAME -> //
              new class_1799(getConverters().toJava(class_1792.class, arg2, "itemType"));
          default -> //
              throw new BadArgumentException("Expected argument of type " + LuaItem.Class.NAME
                  + ", " + LuaBlockType.Class.NAME + ", or" + LuaItemType.Class.NAME);
        };
        class_3218 world = (class_3218) self.getDelegate().method_37908();
        class_1542 itemEntity = self.getDelegate().method_5699(world, itemStack.method_7972(), yOffset);
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(itemEntity));
      }
    }

    class EvaluateFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "evaluate";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        boolean hasPlaceholderApi = FabricLoader.getInstance().isModLoaded("placeholder-api");
        if (!hasPlaceholderApi) {
          throw new UnsupportedOperationException(
              "Placeholder API not found. Please drop placeholder-api-*.jar into mods folder.");
        }
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        String text = getConverters().toJava(String.class, arg2, 2, "text", getName());


        PlaceholderContext ctx = PlaceholderContext.of(self.getDelegate());
        class_2561 parsed = Placeholders.parseText(class_2561.method_43470(text), ctx);
        String value = parsed.getString(); // unformatted text
        context.getReturnBuffer().setTo(getConverters().toLuaNullable(value));
      }
    }

    class PutExtraFunction extends NamedFunction2 {
      @Override
      public String getName() {
        return "putExtra";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2)
          throws ResolvedControlThrowable {
        LuaEntity<?, ?> self = getConverters().toJava(LuaEntity.class, arg1, 1, "self", getName());
        Table nbt = getConverters().toJava(Table.class, arg2, 2, "nbt", getName());
        self.putExtra(nbt);
        context.getReturnBuffer().setTo();
      }
    }
  }

  public LuaEntity(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("world", this::getWorld);
    add("name", this::getName, this::setName);
    addReadOnly("uuid", this::getUuid);
    addReadOnly("type", this::getType);
    addReadOnly("age", this::getAge);
    add("nbt", this::getNbt, this::setNbt);
    add("pos", this::getPos, this::setPos);
    addReadOnly("eyePos", this::getEyePos);
    addReadOnly("lookVec", this::getLookVec);
    add("pitch", this::getPitch, this::setPitch);
    add("yaw", this::getYaw, this::setYaw);
    add("velocity", this::getVelocity, this::setVelocity);
    add("invisible", this::isInvisible, this::setInvisible);
    addReadOnly("alive", this::isAlive);
    add("sprinting", this::isSprinting, this::setSprinting);
    addReadOnly("crawling", this::isCrawling);
    add("sneaking", this::isSneaking, this::setSneaking);
    add("extra", this::getExtra, this::setExtra);
    addReadOnly("facing", this::getFacing);
  }

  private Object getExtra() {
    ExtendedEntity entity = (ExtendedEntity) getDelegate();
    class_2487 extra = entity.getExtra();
    return NbtConverter.toLua(extra);
  }

  private void setExtra(Object luaObject) {
    ExtendedEntity entity = (ExtendedEntity) getDelegate();
    Table data = getConverters().toJava(Table.class, luaObject, "table");
    class_2487 extra = getLuaClass().getNbtConverter().merge(new class_2487(), data);
    entity.setExtra(extra);
  }

  private void putExtra(Table part) {
    ExtendedEntity entity = (ExtendedEntity) getDelegate();
    class_2487 extra = entity.getExtra();
    class_2487 newExtra = getLuaClass().getNbtConverter().merge(extra, part);
    entity.setExtra(newExtra);
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().method_37908());
  }

  protected Object getName() {
    return getConverters().toLua(getDelegate().method_5477().getString());
  }

  protected void setName(Object luaObject) {
    Optional<String> name = getConverters().toJavaOptional(String.class, luaObject, "name");
    getDelegate().method_5665(name.map(class_2561::method_30163).orElse(null));
  }

  protected Object getUuid() {
    return getConverters().toLua(getDelegate().method_5845());
  }

  private Object getType() {
    return getConverters().toLua(getDelegate().method_5864());
  }

  private Object getAge() {
    return getConverters().toLua(getDelegate().field_6012);
  }

  private Object getNbt() {
    class_2487 result = getDelegate().method_5647(new class_2487());
    return NbtConverter.toLua(result);
  }

  private void putNbt(Table nbt) {
    putNbt((class_1297) getDelegate(), getLuaClass().getNbtConverter(), nbt);
  }

  public static void putNbt(class_1297 itemEntity, NbtConverter nbtConverter, Table nbt) {
    class_2487 oldNbt = itemEntity.method_5647(new class_2487());
    class_2487 newNbt = nbtConverter.merge(oldNbt, nbt);
    itemEntity.method_5651(newNbt);
  }

  private void setNbt(Object luaObject) {
    Table data = getConverters().toJava(Table.class, luaObject, "nbt");
    class_2487 newNbt = getLuaClass().getNbtConverter().merge(new class_2487(), data);
    getDelegate().method_5651(newNbt);
  }

  private Object getPos() {
    return getConverters().toLua(getDelegate().method_19538());
  }

  private void setPos(Object luaObject) {
    class_243 pos = getConverters().toJava(class_243.class, luaObject, "pos");
    setPosVec3d(checkPos(pos));
  }

  private class_243 checkPos(class_243 pos) {
    if (!class_1937.method_25953(class_2338.method_49637(pos.field_1352, pos.field_1351, pos.field_1350))) {
      throw new BadArgumentException("Not a valid world position", 1, "pos");
    }
    return pos;
  }

  protected void setPosVec3d(class_243 pos) {
    getDelegate().method_33574(pos);
  }

  private Object getEyePos() {
    return getConverters().toLua(getDelegate().method_33571());
  }

  private Object getLookVec() {
    class_243 result = RaycastUtil.getLookVector(getDelegate(), 1d);
    return getConverters().toLua(result);
  }

  private Object getPitch() {
    return getConverters().toLua(getDelegate().method_36455());
  }

  private void setPitch(Object luaObject) {
    float pitch = getConverters().toJava(float.class, luaObject, "pitch");
    getDelegate().method_36457(pitch);
  }

  private Object getYaw() {
    return getConverters().toLua(getDelegate().method_36454());
  }

  private void setYaw(Object luaObject) {
    float yaw = getConverters().toJava(float.class, luaObject, "yaw");
    getDelegate().method_36456(yaw);
  }

  private Object getVelocity() {
    return getConverters().toLua(getDelegate().method_18798());
  }

  private void setVelocity(Object luaObject) {
    class_243 velocity = getConverters().toJava(class_243.class, luaObject, "velocity");
    getDelegate().method_18799(velocity);
    getDelegate().field_6037 = true;
  }

  private Object isInvisible() {
    return getConverters().toLua(getDelegate().method_5767());
  }

  private void setInvisible(Object luaObject) {
    getDelegate().method_5648(getConverters().toJava(boolean.class, luaObject, "invisible"));
  }

  private Object isAlive() {
    return getConverters().toLua(getDelegate().method_5805());
  }

  private Object isSprinting() {
    return getConverters().toLua(getDelegate().method_5624());
  }

  private void setSprinting(Object luaObject) {
    getDelegate().method_5728(getConverters().toJava(boolean.class, luaObject, "sprinting"));
  }

  private Object isCrawling() {
    return getConverters().toLua(getDelegate().method_20448());
  }

  private Object isSneaking() {
    return getConverters().toLua(getDelegate().method_5715());
  }

  private void setSneaking(Object luaObject) {
    getDelegate().method_5660(getConverters().toJava(boolean.class, luaObject, "sneeking"));
  }

  private Object getFacing() {
    return getConverters().toLua(class_2350.method_10150(getDelegate().method_36454()));
  }
}
