package net.wizardsoflua.lua.classes;

import java.util.Set;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction5;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayer< //
    J extends class_3222, //
    LC extends AbstractLuaClass<?, ?> //
> extends LuaLivingEntity<J, LC> {

  public static class Class
      extends AbstractLuaClass<class_3222, LuaPlayer<class_3222, LuaPlayer.Class>> {
    public Class(SpellScope spellScope, LuaLivingEntity.Class luaSuperclass) {
      super("Player", spellScope, luaSuperclass);
      addFunction(new TeleportFunction());
      addFunction(new SendCommandTreeFunction());
    }

    @Override
    protected LuaPlayer<class_3222, LuaPlayer.Class> createNewLuaInstance(
        class_3222 javaInstance) {
      return new LuaPlayer<>(this, javaInstance);
    }

    class TeleportFunction extends NamedFunction5 {
      @Override
      public String getName() {
        return "teleport";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1, Object arg2, Object arg3,
          Object arg4, Object arg5) throws ResolvedControlThrowable {
        LuaPlayer<?, ?> self = getConverters().toJava(LuaPlayer.class, arg1, 1, "self", getName());
        class_3218 world = getConverters().toJava(class_3218.class, arg2, 2, "world", getName());
        class_243 pos = getConverters().toJava(class_243.class, arg3, 3, "pos", getName());
        Float yaw = getConverters().toJavaNullable(Float.class, arg4, 4, "yaw", getName());
        Float pitch = getConverters().toJavaNullable(Float.class, arg5, 5, "pitch", getName());
        class_3222 player = self.getDelegate();
        boolean resetCamera = true;
        player.method_48105(world, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), yaw == null ? player.method_36454() : yaw,
            pitch == null ? player.method_36455() : pitch, resetCamera);
        context.getReturnBuffer().setTo();
      }
    }

    private class SendCommandTreeFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "sendCommandTree";
      }

      @Override
      public void invoke(ExecutionContext ctx, Object selfArg) throws ResolvedControlThrowable {
        LuaPlayer<?, ?> self =
            getConverters().castTo(LuaPlayer.class, selfArg, 1, "self", getName());
        var player = self.getDelegate();
        var server = player.method_5682();
        var mgr = server.method_3734();
        mgr.method_9241(player);
      }
    }
  }

  public LuaPlayer(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance);
    addReadOnly("blockInteractionRange", this::getBlockInteractionRange);
    add("gamemode", this::getGameMode, this::setGameMode);
    add("mainHandItem", this::getMainHandItem, this::setMainHandItem);
    addReadOnly("permissionLevel", this::getPermissionLevel);
    addReadOnly("inventory", this::getInventory);
  }

  @Override
  protected void setPosVec3d(class_243 pos) {
    class_3222 player = getDelegate();
    boolean resetCamera = true;
    player.method_48105(player.method_51469(), pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), player.method_36454(),
        player.method_36455(), resetCamera);
  }

  private Object getBlockInteractionRange() {
    double result = getDelegate().method_55754();
    return getConverters().toLua(result);
  }

  private Object getGameMode() {
    class_1934 result = getDelegate().field_13974.method_14257();
    return getConverters().toLua(result);
  }

  private void setGameMode(Object luaObject) {
    class_1934 gameMode = getConverters().toJava(class_1934.class, luaObject, "gamemode");
    getDelegate().method_7336(gameMode);
  }

  private Object getMainHandItem() {
    class_1799 result = getDelegate().method_5998(class_1268.field_5808);
    if (result == class_1799.field_8037) {
      return null;
    }
    return getConverters().toLua(result);
  }

  private void setMainHandItem(Object luaObject) {
    class_1799 itemStack = luaObject == null ? class_1799.field_8037
        : getConverters().toJava(class_1799.class, luaObject, "item");
    getDelegate().method_6122(class_1268.field_5808, itemStack);
  }

  private Object getPermissionLevel() {
    GameProfile profile = getDelegate().method_7334();
    int result = getLuaClass().getWorld().method_8503().method_3835(profile);
    return getConverters().toLua(result);
  }

  private Object getInventory() {
    class_1661 inventory = getDelegate().method_31548();
    return getConverters().toLua(inventory);
  }
}
