package net.wizardsoflua.lua.classes;

import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.lua.BadArgumentException;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerInventory< //
    J extends class_1661, //
    LC extends LuaPlayerInventory.Class //
> extends AbstractLuaInstance<J, LC> {

  public static class Class
      extends AbstractLuaClass<class_1661, LuaPlayerInventory<class_1661, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerInventory", spellScope, null);
      addFunction(new ClearFunction());
    }

    @Override
    protected final LuaPlayerInventory<class_1661, Class> createNewLuaInstance(
        class_1661 javaInstance) {
      return new LuaPlayerInventory<>(this, javaInstance);
    }

    class ClearFunction extends NamedFunction1 {
      @Override
      public String getName() {
        return "clear";
      }

      @Override
      public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
        LuaPlayerInventory<?, ?> self =
            getConverters().toJava(LuaPlayerInventory.class, arg1, 1, "self", getName());
        self.getDelegate().method_5448();
        context.getReturnBuffer().setTo();
      }
    }
  }

  public LuaPlayerInventory(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, false);
    add("selectedSlot", this::getSelectedSlot, this::setSelectedSlot);
    addSlots();
  }

  private Object getSelectedSlot() {
    var result = getDelegate().field_7545;
    return getConverters().toLua(result);
  }

  private void setSelectedSlot(Object luaObject) {
    int value = getConverters().toJava(int.class, luaObject, "selectedSlot");
    if (!class_1661.method_7380(value)) {
      throw new BadArgumentException("Bad hotbar index!", 1, "selectedSlot");
    }
    getDelegate().field_7545 = value;
    sendPlayerStatus();
  }

  private void addSlots() {
    J playerInventory = getDelegate();
    int length = playerInventory.method_5439();
    for (int i = 0; i < length; i++) {
      final int slot = i;
      add(slot, () -> getItemAsSlot(slot), it -> setSlot(slot, it));
    }
  }

  private void setSlot(int slot, Object luaObject) {
    class_1799 itemStack = getConverters().toJavaNullable(class_1799.class, luaObject, "item");
    if (itemStack == null) {
      itemStack = class_1799.field_8037;
    }
    getDelegate().method_5447(slot, itemStack);
  }

  private Object getItemAsSlot(int slot) {
    class_1799 result = getDelegate().method_5438(slot);
    if (result == class_1799.field_8037) {
      result = null;
    }
    return getConverters().toLuaNullable(result);
  }

  private void sendPlayerStatus() {
    class_3222 player = getPlayer();
    var server = getLuaClass().getWorld().method_8503();
    server.method_3760().method_14594(player);
  }

  private class_3222 getPlayer() {
    return (class_3222) getDelegate().field_7546;
  }
}
