package net.wizardsoflua.lua.classes;

import net.wizardsoflua.event.PlayerUseItemEvent;
import net.wizardsoflua.spell.SpellScope;

public class LuaPlayerUseItemEvent< //
    J extends PlayerUseItemEvent, //
    LC extends AbstractLuaClass<?, ?> //
> extends AbstractLuaInstance<J, LC> {

  public static class Class extends
      AbstractLuaClass<PlayerUseItemEvent, LuaPlayerUseItemEvent<PlayerUseItemEvent, Class>> {
    public Class(SpellScope spellScope) {
      super("PlayerUseItemEvent", spellScope, null);
    }

    @Override
    protected final LuaPlayerUseItemEvent<PlayerUseItemEvent, Class> createNewLuaInstance(
        PlayerUseItemEvent javaInstance) {
      return new LuaPlayerUseItemEvent<>(this, javaInstance);
    }
  }

  public LuaPlayerUseItemEvent(LC luaClass, J javaInstance) {
    super(luaClass, javaInstance, true);
    addReadOnly("name", this::getName);
    addReadOnly("world", this::getWorld);
    addReadOnly("player", this::getPlayer);
    addReadOnly("hand", this::getHand);
    addReadOnly("item", this::getItem);
  }

  private Object getName() {
    return getConverters().toLua(getDelegate().getClass().getSimpleName());
  }

  private Object getWorld() {
    return getConverters().toLua(getDelegate().world());
  }

  private Object getPlayer() {
    return getConverters().toLua(getDelegate().player());
  }

  private Object getHand() {
    return getConverters().toLua(getDelegate().hand());
  }

  private Object getItem() {
    return getConverters().toLua(getDelegate().itemStack());
  }
}
