package net.wizardsoflua.spell;

import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.chunk.ChunkUtil;
import net.wizardsoflua.chunk.Ticket;

/**
 * The {@link VirtualEntityChunkForceSupport} ensures that the chunk at the {@link VirtualEntity}'s
 * position will stay loaded continuously.
 */
public class VirtualEntityChunkForceSupport {

  private final ChunkForceManager support;
  private final VirtualEntity entity;
  private Ticket chunkLoaderTicket;
  private class_1923 chunkPos;

  public VirtualEntityChunkForceSupport(ChunkForceManager support, VirtualEntity entity) {
    this.support = support;
    this.entity = entity;
    chunkPos = new class_1923(entity.getBlockPos());
    loadChunk(chunkPos);
    loadChunkProximity(chunkPos);
  }

  public void requestNewTicket() {
    if (hasTicket()) {
      releaseTicket();
    }
    chunkPos = new class_1923(entity.getBlockPos());
    chunkLoaderTicket = new Ticket(entity.getWorld());
    if (chunkLoaderTicket == null) {
      throw new IllegalStateException("Could not get a ChunkLoading ticket for Wizards of Lua!");
    }
    loadChunkProximity(chunkPos);
    support.forceChunk(chunkLoaderTicket, chunkPos);
  }

  public boolean hasTicket() {
    return chunkLoaderTicket != null;
  }

  public void releaseTicket() {
    if (hasTicket()) {
      chunkLoaderTicket.release();
      chunkLoaderTicket = null;
    }
  }

  public void updatePosition() {
    class_2338 pos = entity.getBlockPos();
    if (!ChunkUtil.contains(chunkPos, pos)) {
      if (chunkLoaderTicket != null) {
        support.unforceChunk(chunkLoaderTicket, chunkPos);
        chunkPos = new class_1923(pos);
        loadChunkProximity(chunkPos);
        support.forceChunk(chunkLoaderTicket, chunkPos);
      } else {
        chunkPos = new class_1923(pos);
        loadChunk(chunkPos);
        loadChunkProximity(chunkPos);
      }
    }
  }

  private void loadChunk(class_1923 chunkPos) {
    entity.getWorld().method_8497(chunkPos.field_9181, chunkPos.field_9180);
  }

  /**
   * This loads the neighborhood of the chunk at the given position. This ensures that the
   * decoration elements of the world generation process are added to the chunk in the center.
   *
   * @param center
   * @see https://www.reddit.com/r/feedthebeast/comments/5x0twz/investigating_extreme_worldgen_lag/
   */
  private void loadChunkProximity(class_1923 center) {
    for (int x = -1; x <= 1; ++x) {
      for (int z = -1; z <= 1; ++z) {
        if (!(x == 0 && z == 0)) {
          entity.getWorld().method_8497(center.field_9181 + x, center.field_9180 + z);
        }
      }
    }
  }

}
