/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Field;
import java.util.Map;
import net.wizardsoflua.WizardsOfLuaMod;

public class CommandNodeRemover {
    private final Field childrenField;
    private final Field literalsField;
    private final Field argumentsField;

    public CommandNodeRemover() throws ReflectiveOperationException {
        Class<CommandNode> cmdNodeClass = CommandNode.class;
        this.childrenField = cmdNodeClass.getDeclaredField("children");
        this.literalsField = cmdNodeClass.getDeclaredField("literals");
        this.argumentsField = cmdNodeClass.getDeclaredField("arguments");
        this.childrenField.setAccessible(true);
        this.literalsField.setAccessible(true);
        this.argumentsField.setAccessible(true);
    }

    public void removeChildFrom(CommandNode<?> parent, CommandNode<?> child) {
        String key = child.getName();
        try {
            Object childrenObj = this.childrenField.get(parent);
            Object literalsObj = this.literalsField.get(parent);
            Object argumentsObj = this.argumentsField.get(parent);
            if (childrenObj instanceof Map) {
                ((Map)childrenObj).remove(key);
            }
            if (literalsObj instanceof Map) {
                ((Map)literalsObj).remove(key);
            }
            if (argumentsObj instanceof Map) {
                ((Map)argumentsObj).remove(key);
            }
        }
        catch (ReflectiveOperationException e) {
            WizardsOfLuaMod.LOGGER.warn("DynamicCommandManager: could not fully remove internals for '{}': {}", (Object)key, (Object)e.toString());
        }
    }
}

