/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command.dynamic;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wizardsoflua.command.dynamic.ParseResult;
import net.wizardsoflua.command.dynamic.Placeholder;
import net.wizardsoflua.command.dynamic.Token;

public class DynamicCommandParser {
    private static final Pattern ENUM_PATTERN = Pattern.compile("^([a-zA-Z]+)\\[(.+)]$");

    public static ParseResult parse(String pattern) {
        Preconditions.checkArgument((pattern != null && !pattern.isBlank() ? 1 : 0) != 0, (Object)"pattern is missing");
        String[] parts = pattern.trim().split("\\s+");
        ArrayList<Token> tokens = new ArrayList<Token>(parts.length);
        if (parts.length == 0) {
            throw new IllegalArgumentException("No tokens in pattern found!");
        }
        int totalPlaceholders = 0;
        int namedPlaceholders = 0;
        Object tokenPath = "";
        for (int i = 0; i < parts.length; ++i) {
            String raw = parts[i];
            if (raw.startsWith("%")) {
                String placeholderCode = raw.substring(1);
                String nodeName = String.valueOf(++totalPlaceholders);
                List<String> enumValues = null;
                Matcher m = ENUM_PATTERN.matcher(placeholderCode);
                if (m.matches()) {
                    placeholderCode = m.group(1);
                    enumValues = List.of(m.group(2).split("\\|"));
                }
                Placeholder ph = Placeholder.byCode(placeholderCode);
                tokenPath = (String)tokenPath + (String)(((String)tokenPath).isEmpty() ? nodeName : "." + nodeName);
                tokens.add(new Token(raw, (String)tokenPath, nodeName, true, null, ph, enumValues));
                continue;
            }
            if (raw.contains(":%")) {
                ++totalPlaceholders;
                ++namedPlaceholders;
                int idx = raw.indexOf(":%");
                String placeholderName = raw.substring(0, idx);
                if (placeholderName.isEmpty()) {
                    throw new IllegalArgumentException("Placeholder missing name before ':%' in '" + raw + "'");
                }
                String nodeName = placeholderName;
                String placeholderCode = raw.substring(idx + 2);
                List<String> enumValues = null;
                Matcher m = ENUM_PATTERN.matcher(placeholderCode);
                if (m.matches()) {
                    placeholderCode = m.group(1);
                    enumValues = List.of(m.group(2).split("\\|"));
                }
                Placeholder ph = Placeholder.byCode(placeholderCode);
                tokenPath = (String)tokenPath + (String)(((String)tokenPath).isEmpty() ? nodeName : "." + nodeName);
                tokens.add(new Token(raw, (String)tokenPath, nodeName, true, placeholderName, ph, enumValues));
                continue;
            }
            String nodeName = raw;
            tokenPath = (String)tokenPath + (String)(((String)tokenPath).isEmpty() ? nodeName : "." + nodeName);
            tokens.add(new Token(raw, (String)tokenPath, nodeName, false, null, null, null));
        }
        if (namedPlaceholders > 0 && namedPlaceholders < totalPlaceholders) {
            throw new IllegalArgumentException("Invalid command pattern. Either name all placeholders or none of them.");
        }
        return new ParseResult(tokens);
    }
}

