/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import com.google.common.reflect.TypeToken;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.classes.LuaInstanceCache;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.table.PropertyTable;
import net.wizardsoflua.lua.table.XDelegatingLuaTable;
import net.wizardsoflua.spell.SpellScope;
import net.wizardsoflua.world.WorldChunkTracker;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLuaClass<J, L extends AbstractLuaInstance<J, ?>>
extends PropertyTable {
    private final TypeToken<J> typeTokenJ = new TypeToken<J>(((Object)((Object)this)).getClass()){};
    private final Class<J> classJ = this.typeTokenJ.getRawType();
    private final TypeToken<L> typeTokenL = new TypeToken<L>(((Object)((Object)this)).getClass()){};
    private final Class<L> classL = this.typeTokenL.getRawType();
    private final String name;
    @Nullable
    private final AbstractLuaClass<? super J, ?> luaSuperclass;
    private final SpellScope spellScope;

    public AbstractLuaClass(String name, SpellScope spellScope, @Nullable AbstractLuaClass<? super J, ?> luaSuperclass) {
        super(true);
        this.name = Objects.requireNonNull(name, "name");
        this.spellScope = Objects.requireNonNull(spellScope, "spellScope");
        this.luaSuperclass = luaSuperclass;
        if (luaSuperclass != null) {
            super.setMetatable(luaSuperclass);
        }
        this.rawset("__index", (Object)this);
    }

    protected LuaInstanceCache getInstanceCache() {
        return this.spellScope.getInstanceCache();
    }

    public Table setMetatable(Table mt) {
        throw new IllegalOperationAttemptException("illegal attempt to modify metatable for lua class " + String.valueOf((Object)this));
    }

    public AbstractLuaClass<? super J, ?> getLuaSuperclass() {
        return this.luaSuperclass;
    }

    public WorldChunkTracker getWorldChunkTracker() {
        return this.spellScope.getWorldChunkTracker();
    }

    public class_3218 getWorld() {
        return this.spellScope.getWorld();
    }

    public class_2168 getCommandSource() {
        return this.spellScope.getCommandSource();
    }

    public LuaConverters getConverters() {
        return this.spellScope.getConverters();
    }

    public Types getTypes() {
        return this.spellScope.getTypes();
    }

    public NbtConverter getNbtConverter() {
        return this.spellScope.getNbtConverter();
    }

    public WolServerFileSystem getWolServerFileSystem() {
        return this.spellScope.getWolServerFileSystem();
    }

    public String getName() {
        return this.name;
    }

    public Class<J> getJavaClass() {
        return this.classJ;
    }

    public Class<L> getLuaInstanceClass() {
        return this.classL;
    }

    @Nullable
    public J toJava(L luaInstance) {
        return (J)((XDelegatingLuaTable)luaInstance).getDelegate();
    }

    public Object toLua(J javaInstance) {
        return this.getInstanceCache().getOrCreate(javaInstance, this::createNewLuaInstance);
    }

    protected abstract L createNewLuaInstance(J var1);
}

