/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.print;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.lib.BasicLib;
import net.wizardsoflua.lua.module.print.OutputReceiver;
import net.wizardsoflua.lua.module.print.TabEncoder;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class LogRedirector {
    private final OutputReceiver outputReceiver;

    public static LogRedirector installInto(Table env, OutputReceiver outputReceiver) {
        return new LogRedirector(env, outputReceiver);
    }

    public LogRedirector(Table env, OutputReceiver outputReceiver) {
        this.outputReceiver = outputReceiver;
        ChatOutputStream out = new ChatOutputStream();
        BasicLib.Print function = new BasicLib.Print(this, (OutputStream)((Object)out), env){

            protected String name() {
                return "log";
            }
        };
        env.rawset((Object)"log", (Object)function);
    }

    private void print(String message) {
        this.outputReceiver.send(TabEncoder.encode(message));
    }

    private class ChatOutputStream
    extends ByteArrayOutputStream {
        private ChatOutputStream() {
        }

        public void flush() throws IOException {
            String message = this.toString(Charset.defaultCharset());
            if ((message = message.replaceAll("\r", "")).endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            this.reset();
            LogRedirector.this.print(message);
        }
    }
}

