/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.table;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.util.TraversableHashMap;
import net.wizardsoflua.extension.api.Named;
import net.wizardsoflua.lua.table.TableProperty;
import org.jetbrains.annotations.Nullable;

public class PropertyTable
extends Table {
    private final TraversableHashMap<Object, Object> values = new TraversableHashMap();
    private final boolean modifiable;

    public PropertyTable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    private static void checkKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("table index is nil");
        }
        if (key instanceof Double && Double.isNaN((Double)key)) {
            throw new IllegalArgumentException("table index is NaN");
        }
    }

    public Object rawget(Object key) {
        Object result = this.values.get(key = Conversions.normaliseKey((Object)key));
        if (result instanceof TableProperty) {
            result = ((TableProperty)result).get();
        }
        return Conversions.canonicalRepresentationOf((Object)result);
    }

    public void rawset(Object key, Object value) {
        key = Conversions.normaliseKey((Object)key);
        PropertyTable.checkKey(key);
        value = Conversions.canonicalRepresentationOf((Object)value);
        Object p = this.values.get(key);
        if (p instanceof TableProperty) {
            ((TableProperty)p).set(value);
        } else if (this.modifiable) {
            this.values.put(key, value);
        } else {
            throw new IllegalOperationAttemptException("attempt to modify unknown table index");
        }
        this.updateBasetableModes(key, value);
    }

    public Object initialKey() {
        return this.values.getFirstKey();
    }

    public Object successorKeyOf(Object key) {
        try {
            return this.values.getSuccessorOf(key);
        }
        catch (NullPointerException | NoSuchElementException ex) {
            throw new IllegalArgumentException("invalid key to 'next'", ex);
        }
    }

    protected void setMode(boolean weakKeys, boolean weakValues) {
    }

    public <T> void addReadOnly(Object key, Supplier<T> get) {
        this.addProperty(key, new TableProperty<T>(get, null));
    }

    public <T> void add(Object key, @Nullable Supplier<T> get, Consumer<Object> set) {
        Preconditions.checkNotNull(set, (Object)"set == null!");
        this.addProperty(key, new TableProperty<T>(get, set));
    }

    private void addProperty(Object key, TableProperty<?> property) {
        this.add(key, property);
    }

    public <F extends LuaFunction> void addFunction(F function) {
        this.add(((Named)function).getName(), function);
    }

    public void addFunction(Object key, LuaFunction function) {
        this.add(key, function);
    }

    private void add(Object key, Object value) {
        key = Conversions.normaliseKey((Object)key);
        PropertyTable.checkKey(key);
        Preconditions.checkNotNull((Object)value, (Object)"value == null!");
        this.values.put(key, value);
    }
}

