/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.spell.SpellFactory;

public class SpellCaster {
    private final SpellFactory spellFactory;

    public SpellCaster(SpellFactory spellFactory) {
        this.spellFactory = Objects.requireNonNull(spellFactory, "spellFactory");
    }

    public int castNewSpell(class_2168 source, String code) {
        return this.castNewSpell(source, code, Maps.newLinkedHashMap());
    }

    public int castNewSpell(class_2168 source, String code, LinkedHashMap<Object, Object> argsMap) {
        try {
            this.spellFactory.createSpell(source, code, argsMap);
            return 1;
        }
        catch (Throwable t) {
            this.handleException(t, source);
            return 0;
        }
    }

    private void handleException(Throwable t, class_2168 source) {
        String message = String.format("An unexpected error occured during lua command execution: %s", t.getMessage());
        WizardsOfLuaMod.LOGGER.error(message, t);
        String stackTrace = this.getStackTrace(t);
        class_5250 errorText = class_5250.method_43477((class_7417)class_8828.method_54232((String)message)).method_27693(stackTrace);
        source.method_9213((class_2561)errorText);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        Object result = writer.toString();
        if (((String)result).length() > 200) {
            result = ((String)result).substring(0, 200) + "...";
        }
        return result;
    }
}

